/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.compat.jei;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.AgriClientApi;
import com.agricraft.agricraft.api.codecs.AgriSoilCondition;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.requirement.AgriGrowthConditionRegistry;
import com.agricraft.agricraft.api.requirement.AgriSeason;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.util.LangUtils;
import com.agricraft.agricraft.common.util.Platform;
import com.agricraft.agricraft.compat.jei.AgriCraftJeiPlugin;
import java.util.List;
import java.util.function.BooleanSupplier;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_6382;
import net.minecraft.class_7833;

public class CropRequirementCategory
implements IRecipeCategory<Recipe> {
    public static final class_2960 ID = new class_2960("agricraft", "jei/requirement");
    public static final RecipeType<Recipe> TYPE = new RecipeType(ID, Recipe.class);
    public static final IDrawable BACKGROUND = AgriCraftJeiPlugin.createDrawable(new class_2960("agricraft", "textures/gui/jei/crop_requirement.png"), 0, 0, 128, 128, 128, 128);
    public static final class_2960 COMPONENTS = new class_2960("agricraft", "textures/gui/jei/crop_requirement_components.png");
    public static final class_2960 GUI_COMPONENTS = new class_2960("agricraft", "textures/gui/gui_components.png");
    public static final int[] HUMIDITY_OFFSETS = new int[]{8, 8, 10, 10, 10, 7};
    public static final int[] ACIDITY_OFFSETS = new int[]{7, 8, 7, 8, 8, 8, 6};
    public static final int[] NUTRIENTS_OFFSETS = new int[]{6, 8, 9, 9, 11, 10};
    public final IDrawable icon;
    public long lastTime;

    public CropRequirementCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableItemStack(new class_1799((class_1935)class_2246.field_10362));
        this.lastTime = System.currentTimeMillis();
    }

    public RecipeType<Recipe> getRecipeType() {
        return TYPE;
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"agricraft.gui.jei.requirement");
    }

    public IDrawable getBackground() {
        return BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
        builder.setShapeless();
        builder.addSlot(RecipeIngredientRole.INPUT, 56, 3).setSlotName("input_seed").addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)AgriSeedItem.toStack(recipe.plant));
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        long l;
        int i;
        int offset;
        int index;
        recipe.incStrButton.method_48579(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
        recipe.decStrButton.method_48579(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
        recipe.incStageButton.method_48579(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
        recipe.decStageButton.method_48579(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
        for (int i2 = 0; i2 < recipe.currentStrength; ++i2) {
            guiGraphics.method_25290(COMPONENTS, 105, 66 - i2 * 5, 0.0f, 66.0f, 7, 3, 128, 128);
        }
        int maxHeight = 48;
        int stageHeight = (int)((double)maxHeight * recipe.currentStage.growthPercentage());
        int stageY = 21 + maxHeight - stageHeight;
        guiGraphics.method_25293(COMPONENTS, 93, stageY, 7, stageHeight, 0.0f, 69.0f, 7, 1, 128, 128);
        for (int i3 = 15; i3 >= 0; --i3) {
            boolean fertile = AgriGrowthConditionRegistry.getLight().apply(recipe.plant, recipe.currentStrength, i3).isFertile();
            if (!fertile) continue;
            guiGraphics.method_25293(COMPONENTS, 32, 26 + 3 * (15 - i3), 3, 3, 0.0f, (float)(18 + 3 * (15 - i3)), 3, 3, 128, 128);
        }
        for (AgriSoilCondition.Humidity humidity : AgriSoilCondition.Humidity.values()) {
            if (!humidity.isValid() || !AgriGrowthConditionRegistry.getHumidity().apply(recipe.plant, recipe.currentStrength, humidity).isFertile()) continue;
            index = humidity.ordinal();
            offset = 0;
            for (i = 0; i < index; ++i) {
                offset += HUMIDITY_OFFSETS[i];
            }
            guiGraphics.method_25293(GUI_COMPONENTS, 37 + offset, 83, HUMIDITY_OFFSETS[index], 12, (float)offset, 0.0f, HUMIDITY_OFFSETS[index], 12, 128, 128);
        }
        for (Enum enum_ : AgriSoilCondition.Acidity.values()) {
            if (!((AgriSoilCondition.Acidity)enum_).isValid() || !AgriGrowthConditionRegistry.getAcidity().apply(recipe.plant, recipe.currentStrength, (AgriSoilCondition.Acidity)enum_).isFertile()) continue;
            index = enum_.ordinal();
            offset = 0;
            for (i = 0; i < index; ++i) {
                offset += ACIDITY_OFFSETS[i];
            }
            guiGraphics.method_25293(GUI_COMPONENTS, 37 + offset, 96, ACIDITY_OFFSETS[index], 12, (float)offset, 12.0f, ACIDITY_OFFSETS[index], 12, 128, 128);
        }
        for (Enum enum_ : AgriSoilCondition.Nutrients.values()) {
            if (!((AgriSoilCondition.Nutrients)enum_).isValid() || !AgriGrowthConditionRegistry.getNutrients().apply(recipe.plant, recipe.currentStrength, (AgriSoilCondition.Nutrients)enum_).isFertile()) continue;
            index = enum_.ordinal();
            offset = 0;
            for (i = 0; i < index; ++i) {
                offset += NUTRIENTS_OFFSETS[i];
            }
            guiGraphics.method_25293(GUI_COMPONENTS, 37 + offset, 109, NUTRIENTS_OFFSETS[index], 12, (float)offset, 24.0f, NUTRIENTS_OFFSETS[index], 12, 128, 128);
        }
        if (AgriApi.getSeasonLogic().isActive()) {
            for (Enum enum_ : AgriSeason.values()) {
                if (enum_ == AgriSeason.ANY || !AgriGrowthConditionRegistry.getSeason().apply(recipe.plant, recipe.currentStrength, (AgriSeason)enum_).isFertile()) continue;
                guiGraphics.method_25290(GUI_COMPONENTS, 17, 24 + 13 * enum_.ordinal(), (float)(10 * enum_.ordinal()), 44.0f, 10, 12, 128, 128);
            }
        }
        if (this.lastTime + 1500L <= (l = System.currentTimeMillis()) && !class_437.method_25442()) {
            recipe.tick();
            this.lastTime = l;
        }
        class_4587 stack = guiGraphics.method_51448();
        stack.method_22903();
        class_308.method_24210();
        stack.method_46416(56.0f, 53.0f, 0.0f);
        stack.method_46416(-4.0f, 12.0f, 0.0f);
        stack.method_22905(16.0f, -16.0f, 1.0f);
        stack.method_22907(class_7833.field_40714.rotationDegrees(45.0f));
        stack.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
        class_4597.class_4598 class_45982 = class_310.method_1551().method_22940().method_23000();
        if (!recipe.soils.isEmpty() && recipe.soil < recipe.soils.size()) {
            stack.method_22903();
            class_310.method_1551().method_1541().method_3353(recipe.soils.get(recipe.soil).method_9564(), stack, (class_4597)class_45982, 0xF000F0, class_4608.field_21444);
            stack.method_22909();
        }
        class_1087 model = AgriClientApi.getPlantModel(recipe.plantId, recipe.currentStage.index());
        stack.method_22903();
        stack.method_46416(0.0f, 1.0f, 0.0f);
        class_310.method_1551().method_1541().method_3350().method_3367(stack.method_23760(), guiGraphics.method_51450().getBuffer(class_1921.method_23579()), null, model, 1.0f, 1.0f, 1.0f, 0xF000F0, class_4608.field_21444);
        stack.method_22909();
        class_45982.method_22993();
        stack.method_22909();
    }

    public boolean handleInput(Recipe recipe, double mouseX, double mouseY, class_3675.class_306 input) {
        int mouseButton;
        if (input.method_1442() == class_3675.class_307.field_1672 && (mouseButton = input.method_1444()) == 0) {
            if (recipe.incStrButton.method_25405(mouseX, mouseY)) {
                recipe.incStrButton.method_25306();
                return true;
            }
            if (recipe.decStrButton.method_25405(mouseX, mouseY)) {
                recipe.decStrButton.method_25306();
                return true;
            }
            if (recipe.incStageButton.method_25405(mouseX, mouseY)) {
                recipe.incStageButton.method_25306();
                return true;
            }
            if (recipe.decStageButton.method_25405(mouseX, mouseY)) {
                recipe.decStageButton.method_25306();
                return true;
            }
        }
        return super.handleInput((Object)recipe, mouseX, mouseY, input);
    }

    public List<class_2561> getTooltipStrings(Recipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int i;
        int offset;
        if (104.0 <= mouseX && mouseX <= 113.0 && 20.0 <= mouseY && mouseY <= 70.0) {
            return List.of(class_2561.method_43469((String)"agricraft.tooltip.jei.strength", (Object[])new Object[]{recipe.currentStrength}));
        }
        if (92.0 <= mouseX && mouseX <= 101.0 && 20.0 <= mouseY && mouseY <= 70.0) {
            return List.of(class_2561.method_43469((String)"agricraft.tooltip.jei.stage", (Object[])new Object[]{recipe.currentStage.index()}));
        }
        if (32.0 <= mouseX && mouseX <= 35.0 && 26.0 <= mouseY && mouseY <= 73.0) {
            int light = 15 - (int)(mouseY - 26.0) / 3;
            return List.of(class_2561.method_43469((String)"agricraft.tooltip.jei.light", (Object[])new Object[]{light}));
        }
        if (83.0 <= mouseY && mouseY <= 95.0) {
            offset = 0;
            for (i = 0; i < HUMIDITY_OFFSETS.length; ++i) {
                if ((double)(37 + offset) <= mouseX && mouseX <= (double)(37 + offset + HUMIDITY_OFFSETS[i])) {
                    AgriSoilCondition.Humidity humidity = AgriSoilCondition.Humidity.values()[i];
                    return List.of(class_2561.method_43471((String)("agricraft.soil.humidity." + humidity.name().toLowerCase())));
                }
                offset += HUMIDITY_OFFSETS[i];
            }
        }
        if (96.0 <= mouseY && mouseY <= 108.0) {
            offset = 0;
            for (i = 0; i < ACIDITY_OFFSETS.length; ++i) {
                if ((double)(37 + offset) <= mouseX && mouseX <= (double)(37 + offset + ACIDITY_OFFSETS[i])) {
                    AgriSoilCondition.Acidity acidity = AgriSoilCondition.Acidity.values()[i];
                    return List.of(class_2561.method_43471((String)("agricraft.soil.acidity." + acidity.name().toLowerCase())));
                }
                offset += ACIDITY_OFFSETS[i];
            }
        }
        if (109.0 <= mouseY && mouseY <= 121.0) {
            offset = 0;
            for (i = 0; i < NUTRIENTS_OFFSETS.length; ++i) {
                if ((double)(37 + offset) <= mouseX && mouseX <= (double)(37 + offset + NUTRIENTS_OFFSETS[i])) {
                    AgriSoilCondition.Nutrients nutrients = AgriSoilCondition.Nutrients.values()[i];
                    return List.of(class_2561.method_43471((String)("agricraft.soil.nutrients." + nutrients.name().toLowerCase())));
                }
                offset += NUTRIENTS_OFFSETS[i];
            }
        }
        if (50.0 <= mouseX && mouseX <= 76.0 && 34.0 <= mouseY && mouseY <= 58.0) {
            class_2561 desc = LangUtils.plantDescription(recipe.plantId);
            return desc == null ? List.of(LangUtils.plantName(recipe.plantId)) : List.of(LangUtils.plantName(recipe.plantId), desc);
        }
        if (50.0 <= mouseX && mouseX <= 76.0 && 58.0 <= mouseY && mouseY <= 74.0) {
            return class_437.method_25408((class_310)class_310.method_1551(), (class_1799)new class_1799((class_1935)recipe.soils.get(recipe.soil)));
        }
        if (AgriApi.getSeasonLogic().isActive()) {
            if (17.0 <= mouseX && mouseX <= 29.0 && 24.0 <= mouseY && mouseY <= 36.0) {
                return List.of(LangUtils.seasonName(AgriSeason.SPRING));
            }
            if (17.0 <= mouseX && mouseX <= 29.0 && 37.0 <= mouseY && mouseY <= 49.0) {
                return List.of(LangUtils.seasonName(AgriSeason.SUMMER));
            }
            if (17.0 <= mouseX && mouseX <= 29.0 && 50.0 <= mouseY && mouseY <= 62.0) {
                return List.of(LangUtils.seasonName(AgriSeason.AUTUMN));
            }
            if (17.0 <= mouseX && mouseX <= 29.0 && 63.0 <= mouseY && mouseY <= 74.0) {
                return List.of(LangUtils.seasonName(AgriSeason.WINTER));
            }
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public static class Recipe {
        private final AgriPlant plant;
        private final String plantId;
        private final Btn incStrButton;
        private final Btn decStrButton;
        private final Btn incStageButton;
        private final Btn decStageButton;
        private int currentStrength = AgriApi.getStatRegistry().strengthStat().getMin();
        private AgriGrowthStage currentStage;
        private List<class_2248> soils;
        private int soil;

        public Recipe(AgriPlant plant) {
            this.plant = plant;
            this.plantId = AgriApi.getPlantId(plant).map(class_2960::toString).orElse("");
            this.currentStage = plant.getInitialGrowthStage();
            this.incStrButton = new Btn(104, 10, 9, 9, this::incrementStrength, true);
            this.decStrButton = new Btn(104, 71, 9, 9, this::decrementStrength, false);
            this.incStageButton = new Btn(92, 10, 9, 9, this::incrementStage, true);
            this.decStageButton = new Btn(92, 71, 9, 9, this::decrementStage, false);
            this.updateSoils();
        }

        public boolean incrementStrength() {
            this.currentStrength = Math.min(AgriApi.getStatRegistry().strengthStat().getMax(), this.currentStrength + 1);
            this.updateSoils();
            return true;
        }

        public boolean decrementStrength() {
            this.currentStrength = Math.max(AgriApi.getStatRegistry().strengthStat().getMin(), this.currentStrength - 1);
            this.updateSoils();
            return true;
        }

        public boolean incrementStage() {
            this.currentStage = this.currentStage.getNext(null, null);
            return true;
        }

        public boolean decrementStage() {
            this.currentStage = this.currentStage.getPrevious(null, null);
            return true;
        }

        public void updateSoils() {
            this.soils = AgriApi.getSoilRegistry().map(registry -> registry.method_10220().filter(soil -> {
                boolean humidity = AgriGrowthConditionRegistry.getHumidity().apply(this.plant, this.currentStrength, soil.humidity()).isFertile();
                boolean acidity = AgriGrowthConditionRegistry.getAcidity().apply(this.plant, this.currentStrength, soil.acidity()).isFertile();
                boolean nutrients = AgriGrowthConditionRegistry.getNutrients().apply(this.plant, this.currentStrength, soil.nutrients()).isFertile();
                return humidity && acidity && nutrients;
            }).flatMap(soil -> soil.variants().stream()).flatMap(variant -> Platform.get().getBlocksFromLocation(variant.block()).stream()).distinct().toList()).orElse(List.of());
            this.soil = 0;
        }

        public void tick() {
            ++this.soil;
            if (this.soil >= this.soils.size()) {
                this.soil = 0;
            }
        }
    }

    public static class Btn
    extends class_4264 {
        private final boolean isIncrement;
        private final BooleanSupplier onPress;

        protected Btn(int x, int y, int width, int height, BooleanSupplier onPress, boolean isIncrement) {
            super(x, y, width, height, (class_2561)class_2561.method_43473());
            this.isIncrement = isIncrement;
            this.onPress = onPress;
        }

        public void method_25306() {
            this.onPress.getAsBoolean();
        }

        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            int vOffset = this.isIncrement ? 9 : 0;
            int uOffset = this.getUOffset();
            this.field_22762 = this.method_46426() <= mouseX && mouseX < this.method_46426() + this.method_25368() && this.method_46427() <= mouseY && mouseY < this.method_46427() + this.method_25364();
            guiGraphics.method_25290(COMPONENTS, this.method_46426(), this.method_46427(), (float)uOffset, (float)vOffset, 9, 9, 128, 128);
        }

        private int getUOffset() {
            if (class_310.method_1551().field_1729.method_1608()) {
                return 9;
            }
            if (this.field_22762) {
                return 18;
            }
            return 0;
        }

        protected void method_47399(class_6382 narrationElementOutput) {
            this.method_37021(narrationElementOutput);
        }
    }
}

